/************************************************************************
	Header }bvf[^
													[ Mar.08, 1994 ]
 ************************************************************************/

#define	SHAPE_GROUND	1
#define	SHAPE_OBJECT	2

typedef unsigned char	uchar;

 ************************************************************************/
	0 I
	1
	S00000CC AAAAAAAA

	S .......  0  8bit	
			   1  16bit
	C .......  0  momal
			   1  X
			   2  Y
			   3  Z

	A .......  (animation)  0 ... ff


/**************** |CgER[h ********************************/
typedef struct {
	short	pointX;			/* _wW							*/
	short	pointY;			/* _xW							*/
	short	pointZ;			/* _yW							*/
} WPoint;

typedef struct {
	char	pointX;			/* _wW							*/
	char	pointY;			/* _xW							*/
	char	pointZ;			/* _yW							*/
} BPoint;

typedef union {
	BPoint	*byte;
	WPoint	*word;
} PointSize;

typedef struct {
	short		code;
	short		npoints;
	PointSize	*point;
} PointData,*PointPtr;

/********************************************************************
	Polygon structures.
 ********************************************************************/

/**************** Face record ***************************************/
typedef struct {
	short	npoints;		/* number of points						*/
	short	color;			/* polygon color						*/
	short	normalX;		/* normal vector x axis	(1 = 4000H)		*/
	short	normalY;		/* normal vector y axis	(1 = 4000H)		*/
	short	normalZ;		/* normal vector z axis	(1 = 4000H)		*/
	uchar	point[4];		/* array of the point number			*/
} Face3,Face4;

typedef struct {
	short	npoints;		/* number of points						*/
	short	color;			/* polygon color						*/
	short	normalX;		/* normal vector x axis	(1 = 4000H)		*/
	short	normalY;		/* normal vector y axis	(1 = 4000H)		*/
	short	normalZ;		/* normal vector z axis	(1 = 4000H)		*/
	uchar	point[6];		/* array of the point number			*/
} Face5,Face6;

/**************** Plane record **************************************/
typedef struct {
	short	npoints;		/* number of points						*/
	short	color;			/* polygon color						*/
	short	normalX;		/* normal vector x axis	(1 = 4000H)		*/
	short	normalY;		/* normal vector y axis	(1 = 4000H)		*/
	short	normalZ;		/* normal vector z axis	(1 = 4000H)		*/
	uchar	point[4];		/* array of the point number			*/
	short	xmax;			/* maximum value of the x axis			*/
	short	xmin;			/* minimum value of the x axis			*/
	short	ymax;			/* maximum value of the y axis			*/
	short	ymin;			/* minimum value of the y axis			*/
	short	zmax;			/* maximum value of the z axis			*/
	short	zmin;			/* minimum value of the z axis			*/
} Plane3,Plane4;

typedef struct {
	short	npoints;		/* number of points						*/
	short	color;			/* polygon color						*/
	short	normalX;		/* normal vector x axis	(1 = 4000H)		*/
	short	normalY;		/* normal vector y axis	(1 = 4000H)		*/
	short	normalZ;		/* normal vector z axis	(1 = 4000H)		*/
	uchar	point[6];		/* array of the point number			*/
	short	xmax;			/* maximum value of the x axis			*/
	short	xmin;			/* minimum value of the x axis			*/
	short	ymax;			/* maximum value of the y axis			*/
	short	ymin;			/* minimum value of the y axis			*/
	short	zmax;			/* maximum value of the z axis			*/
	short	zmin;			/* minimum value of the z axis			*/
} Plane5,Plane6;

/**************** BSP record ****************************************/
typedef struct {
	short	code;			/* BSP code								*/
	short	face;			/* face number							*/
	FacePtr	left;			/* pointer to the left branch			*/
	FacePtr	right;			/* pointer to the right branch			*/
} BSP;

/**************** Face block record *********************************/
typedef struct {
	short	code;			/* BSP code								*/
	short	face;			/* first face number					*/
	short	count;			/* number of the faces					*/
} Faces;

/**************** Shape information record **************************/
typedef struct {
	uchar		scale;		/* scalling								*/
	uchar		nfaces;		/* number of the faces					*/
	short		radius;		/* radius of the shape					*/
	short		xmax;		/* maximum value of the x axis			*/
	short		ymax;		/* maximum value of the y axis			*/
	short		zmax;		/* maximum value of the z axis			*/

	FacePtr		*vizlist;	/* pointer to the visible list			*/
	PointData	*vertex;	/* pointer to the vertex list			*/
	short		*polygon;	/* pointer to the polygon list			*/
} ShapeInfo,*ShapePtr;





/**************** IuWFNgER[h ****************************/
typedef struct {
	ShapePtr	shape;		/* VF[vf[^ւ̃|C^			*/
	char		flags;		/* }bvf[^ʃtbO				*/
} AnyObjInfo,*AnyObjPtr;

/**************** n㕨R[h ************************************/
typedef struct {
	ShapePtr	shape;		/* VF[vf[^ւ̃|C^			*/
	char		flags;		/* }bvf[^ʃtbO				*/
	char		angY;		/* x܂̉]px					*/
	short		posX;		/* ʒuwW							*/
	short		posZ;		/* ʒuyW							*/
} GroundInfo,*GroundPtr;

/**************** ړR[h ************************************/

typedef struct {
	ShapePtr	shape;		/* VF[vf[^ւ̃|C^			*/
	char		flags;		/* }bvf[^ʃtbO				*/
	char		reserved;	/* \									*/
	double		positionX;	/* ʒuwW							*/
	double		positionY;	/* ʒuxW							*/
	double		positionZ;	/* ʒuyW							*/
	double		angleX;		/* w܂̉]px					*/
	double		angleY;		/* x܂̉]px					*/
	double		angleZ;		/* y܂̉]px					*/
} EnemyInfo,*EnemyPtr;



/**************** J䃌R[h ********************************/
typedef struct {
	double		positionX;	/* JʒuwW						*/
	double		positionY;	/* JʒuxW						*/
	double		positionZ;	/* JʒuyW						*/
	double		offsetX;	/* JʒuItZbgw				*/
	double		offsetY;	/* JʒuItZbgx				*/
	double		offsetZ;	/* JʒuItZbgy				*/
	double		angleX;		/* Jw܂̉]px			*/
	double		angleY;		/* Jx܂̉]px			*/
	double		angleZ;		/* Jy܂̉]px			*/
} CameraInfo,*CameraPtr;

/**************** `惊Xgp **********************************/

typedef union {
	AnyObjPtr anyobj;		/* IuWFNgւ̃|C^				*/
	GroundPtr ground;		/* n㕨ւ̃|C^					*/
	EnemyPtr  enemy;		/* ړւ̃|C^					*/
} Object;

typedef struct DList {
	Object		 object;
	double		 rotateX;
	double		 rotateY;
	double		 rotateZ;
	double		 sortZ;
	struct DList *next;
} DrawList,*DrawListPtr;

/**************** n㕨񃌃R[h ********************************/
typedef struct {
	short	  count;		/* n㕨̌							*/
	GroundPtr ground;		/* n㕨ւ̃|C^					*/
} WorldInfo;

typedef struct {
	short	 posx;
	short	 posy;
	short	 posz;
	short	 angx;
	short	 angy;
	short	 angz;
	ShapePtr shape;
} MapInfo,*MapPtr;

