Shader "Xiexe/XSFur2.0"
{
	Properties
	{
        [Enum(Unity Default, 0, Non Linear, 1)]_LightProbeMethod("Light Probe Sampling", Int) = 0
        [Enum(UVs, 0, Triplanar World, 1, Triplanar Object, 2)]_TextureSampleMode("Texture Mode", Int) = 0
        _TriplanarFalloff("Triplanar Blend", Range(0.5,1)) = 1
        _MainTex ("Main Texture", 2D) = "white" {}
        _Cutoff("Cutoff", Range(0,1)) = 0.5

        _Color ("Top Color", Color) = (1,1,1,1)
        _BottomColor("Bottom Color", Color) = (1,1,1,1)
        _ColorFalloffMin("Color Falloff Min", Range(0,1)) = 0
        _ColorFalloffMax("Color Falloff Max", Range(0,1)) = 1

        _FurTexture("Fur Texture", 2D) = "white" {}
        _FurLengthMask("Length Mask", 2D) = "white" {}
        _NoiseTexture("Noise Texture", 2D) = "white" {}
        [IntRange]_LayerCount("Fur Layer Count", Range(1,10)) = 10
        _FurLength("Fur Length", Range(0,1)) = 0.2
        _FurWidth("Fur Width", Range(0,1)) = 0.1
        _Gravity("Gravity", Range(0,1)) = 0
        _CombX("Comb X", Range(-1,1)) = 0
        _CombY("Comb Y", Range(-1,1)) = 0
        _FurOcclusion("Fur Occlusion", Range(0,1)) = 0.5
        _OcclusionFalloffMin("Occlusion Falloff Min", Range(0,1)) = 0
        _OcclusionFalloffMax("Occlusion Falloff Max", Range(0,1)) = 1
        
        _BumpMap("Normal Map", 2D) = "bump" {}
        _BumpScale("Normal Scale", Range(-1,1)) = 1
        
        _MetallicGlossMap("Metallic Map", 2D) = "white" {}
        [Gamma] _Metallic("Metallic", Range(0,1)) = 0
        _Glossiness("Smoothness", Range(0,1)) = 0
        _Reflectance("Reflectance", Range(0,1)) = 0.5
        _Anisotropy("Anisotropy", Range(-1,1)) = 0

        _OcclusionMap("Occlusion Map", 2D) = "white" {}
        _OcclusionColor("Occlusion Color", Color) = (0,0,0,1)
        
        _EmissionMap("Emission Map", 2D) = "white" {}
        [HDR]_EmissionColor("Emission Color", Color) = (0,0,0,1)
        _EmissionFalloffMin("Emission Falloff Min", Range(0,1)) = 0
        _EmissionFalloffMax("Emission Falloff Max", Range(0,1)) = 1
        
        _ClearcoatMap("Clearcoat Map", 2D) = "white" {}
        _Clearcoat("Clearcoat", Range(0,1)) = 0
        _ClearcoatGlossiness("Clearcoat Smoothness", Range(0,1)) = 0.5
        _ClearcoatAnisotropy("Clearcoat Anisotropy", Range(-1,1)) = 0
        
        _SpecularLMOcclusion("Specular Occlusion", Range(0,1)) = 0
        _SpecLMOcclusionAdjust("Spec Occlusion Sensitiviy", Range(0,1)) = 0.2
        _LMStrength("Lightmap Strength", Range(0,1)) = 1
        _RTLMStrength("Realtime Lightmap Strength", Range(0,1)) = 1
    }

	SubShader
	{
        Tags{"RenderType"="TrasparentCutout" "Queue"="AlphaTest"}
        
		Pass
		{
            Tags {"LightMode"="ForwardBase"}
			CGPROGRAM
			#pragma vertex vert
            #pragma geometry geom
			#pragma fragment frag
            #pragma multi_compile _ VERTEXLIGHT_ON
            #pragma multi_compile_fwdbase
            #pragma target 5.0
            #define GEOMETRY
            #define ALPHATEST

            #ifndef UNITY_PASS_FORWARDBASE
                #define UNITY_PASS_FORWARDBASE
            #endif
			
			#include "UnityCG.cginc"
            #include "Lighting.cginc"
            #include "AutoLight.cginc"
            
			struct appdata
			{
				float4 vertex : POSITION;
				float2 uv : TEXCOORD0;
                float2 uv1 : TEXCOORD1;
                float2 uv2 : TEXCOORD2;
                float3 normal : NORMAL;
                float4 tangent : TANGENT;
			};

			struct v2g
			{
                float4 vertex : SV_POSITION;
				float2 uv : TEXCOORD0;
                float2 uv1 : TEXCOORD1;
                float2 uv2 : TEXCOORD2;
                float3 normal : TEXCOORD3;
                float4 tangent : TEXCOORD4;
			};

            struct g2f
            {
                float4 pos : SV_POSITION;
				float2 uv : TEXCOORD0;
                float2 uv1 : TEXCOORD1;
                float2 uv2 : TEXCOORD2;
                float3 btn[3] : TEXCOORD3; //TEXCOORD2, TEXCOORD3 | bitangent, tangent, worldNormal
                float3 worldPos : TEXCOORD6;
                float3 objPos : TEXCOORD7;
                float3 objNormal : TEXCOORD8;
                float4 screenPos : TEXCOORD9;
                int layer : TEXCOORD10;
                SHADOW_COORDS(11)
            };

            #include "Defines.cginc"
            #include "LightingFunctions.cginc"
            #include "LightingBRDF.cginc"
			#include "VertFragGeom.cginc"
			
			ENDCG
		}

        Pass
		{
            Tags {"LightMode"="ForwardAdd"}
            Blend One One
            ZWrite Off
            
			CGPROGRAM
			#pragma vertex vert
            #pragma geometry geom
			#pragma fragment frag
            #pragma multi_compile_fwdadd_fullshadows
            #pragma target 5.0
            #define GEOMETRY
            #define ALPHATEST

            #ifndef UNITY_PASS_FORWARDADD
                #define UNITY_PASS_FORWARDADD
            #endif
			
			#include "UnityCG.cginc"
            #include "Lighting.cginc"
            #include "AutoLight.cginc"
            
			struct appdata
			{
				float4 vertex : POSITION;
				float2 uv : TEXCOORD0;
                float3 normal : NORMAL;
                float4 tangent : TANGENT;
			};

			struct v2g
			{
                float4 vertex : SV_POSITION;
				float2 uv : TEXCOORD0;
                float3 normal : TEXCOORD1;
                float4 tangent : TEXCOORD2;
			};

            struct g2f
            {
                float4 pos : SV_POSITION;
				float2 uv : TEXCOORD0;
                float3 btn[3] : TEXCOORD1; //TEXCOORD2, TEXCOORD3 | bitangent, tangent, worldNormal
                float3 worldPos : TEXCOORD4;
                float3 objPos : TEXCOORD5;
                float3 objNormal : TEXCOORD6;
                float4 screenPos : TEXCOORD7;
                int layer : TEXCOORD8;
                SHADOW_COORDS(9)
            };

			
            #include "Defines.cginc"
            #include "LightingFunctions.cginc"
            #include "LightingBRDF.cginc"
			#include "VertFragGeom.cginc"
			
			ENDCG
		}

        Pass
        {
            Tags{"LightMode" = "ShadowCaster"} //Removed "DisableBatching" = "True". If issues arise re-add this.
            Cull Off
            CGPROGRAM
            #include "UnityCG.cginc" 
            #include "Lighting.cginc"
            #include "AutoLight.cginc"
            #pragma vertex vert
            #pragma fragment frag
            #pragma geometry geom
            #pragma multi_compile_shadowcaster
            #pragma target 5.0
            #define GEOMETRY
            #define ALPHATEST
            
            #ifndef UNITY_PASS_SHADOWCASTER
                #define UNITY_PASS_SHADOWCASTER
            #endif
            
            struct appdata
			{
				float4 vertex : POSITION;
				float2 uv : TEXCOORD0;
                float3 normal : NORMAL;
                float4 tangent : TANGENT;
			};

			struct v2g
			{
                float4 vertex : SV_POSITION;
				float2 uv : TEXCOORD0;
                float3 normal : TEXCOORD1;
                float4 tangent : TEXCOORD2;
			};

            struct g2f
            {
                float4 pos : SV_POSITION;
				float2 uv : TEXCOORD0;
                float3 btn[3] : TEXCOORD1; //TEXCOORD2, TEXCOORD3 | bitangent, tangent, worldNormal
                float3 worldPos : TEXCOORD4;
                float3 objPos : TEXCOORD5;
                float3 objNormal : TEXCOORD6;
                float4 screenPos : TEXCOORD7;
                int layer : TEXCOORD8;
            };

            #include "Defines.cginc"
            #include "LightingFunctions.cginc"
            #include "VertFragGeom.cginc"
            ENDCG
        }
	}
    CustomEditor "XSFurInspector"
}
